#include <iostream>
#include <vector>
#include <string>
#include <map>
#include <list>
#include <set>
#include <algorithm>
#include <math.h>
using namespace std;


vector<int> Zlato;
vector<int> Resenja;

class Graph {
	map<int, list<pair<int, int>>> l;

public:
	void addEdge(int x, int y, int wt) {
		l[x].push_back({ y, wt });
		l[y].push_back({ x, wt });
	}

	void print() {
		for (auto p : l) {
			int node = p.first;
			cout << node << " -> ";

			for (auto nbr : l[node]) {
				cout << "(" << nbr.first << "," << nbr.second << ") ";
			} cout << endl;
		}
	}

	void djikstraSSSP(int src) {

		map<int, int> dist;

		for (auto p : l) {
			int node = p.first;
			dist[node] = INT_MAX;
		}
		dist[src] = 0;

		set<pair<int, int>> s;
		s.insert({ dist[src], src });

		while (!s.empty()) {

			pair<int, int> p = *s.begin();
			s.erase(s.begin());
			int currNode = p.second;
			int currNodeDist = p.first;

			// visit all nbrs of node
			for (auto nbr : l[currNode]) {
				int nbrNode = nbr.first;
				int distInBetween = nbr.second * Zlato[nbrNode - 1];
				int nbrNodeDist = dist[nbrNode];

				if (currNodeDist + distInBetween < nbrNodeDist) {

					auto pr = s.find({ dist[nbrNode], nbrNode });
					if (pr != s.end()) {
						s.erase(pr);
					}
					dist[nbrNode] = currNodeDist + distInBetween;
					s.insert({ dist[nbrNode], nbrNode });
				}
			}

		}

		for (auto x : dist) {
			cout << x.first << " is at distance " << x.second << " from source" << endl;
		}



	}

};

void PopuniBanke(Graph& Banke, int& Brojac, int Broj)
{
	if (Brojac == Broj) return;
	int temp1, temp2;
	cin >> temp1 >> temp2;
	Banke.addEdge(temp1, temp2, 1);

	PopuniBanke(Banke, ++Brojac, Broj);
}

void PopuniZlato(vector<int>& V, int& Brojac, int Broj)
{
	if (Brojac == Broj) return;
	int temp;
	cin >> temp;
	V.push_back(temp);

	PopuniZlato(V, ++Brojac, Broj);
}

void PopuniScenarije(std::vector<pair<int, int>>& V, int& Brojac, int Broj)
{
	if (Brojac == Broj) return;
	int temp1, temp2;
	cin >> temp1 >> temp2;
	V.push_back(pair<int, int>(temp1, temp2));

	PopuniScenarije(V, ++Brojac, Broj);
}

int medijan(vector<int>& v)
{
	size_t n = v.size() / 2;
	nth_element(v.begin(), v.begin() + n, v.end());
	return n + 1;
}

int main() 
{
	Graph Banke;
	vector<pair<int, int>> Scenariji;
	int BrojScenarija, BrojBanki, Brojac = 0;
	cin >> BrojBanki;
	PopuniBanke(Banke, Brojac, BrojBanki - 1);
	Brojac = 0;
	PopuniZlato(Zlato, Brojac, BrojBanki);
	Brojac = 0;
	cin >> BrojScenarija;
	PopuniScenarije(Scenariji, Brojac, BrojScenarija);
	if (*max_element(Zlato.begin(), Zlato.end()) == *min_element(Zlato.begin(), Zlato.end())) {
		cout << ceil(BrojBanki / 2) + 1 << endl;
	}
	else {
		cout << max_element(Zlato.begin(), Zlato.end()) - Zlato.begin() + 1 << endl;
	}
	for (int i = 0; i < BrojScenarija; i++)
	{
		Zlato[Scenariji[i].second - 1] += Scenariji[i].first;
		if (*max_element(Zlato.begin(), Zlato.end()) == *min_element(Zlato.begin(), Zlato.end())) {
			cout << floor(BrojBanki / 2) << endl;
		}
		else if (*max_element(Zlato.begin(), max_element(Zlato.begin(), Zlato.end())) == *min_element(Zlato.begin(), Zlato.end()))
		{
			auto ite = (max_element(Zlato.begin(), Zlato.end()) - Zlato.begin()) + 1;
			cout << ite << endl;
		}
		else {
			auto ite = (max_element(Zlato.begin(), Zlato.end()) - Zlato.begin()) + 1;
			auto largest = (max_element(Zlato.begin(), Zlato.end()));
			auto secondLargest = max_element(Zlato.begin(), largest);
			auto secondLargestIte = (secondLargest - Zlato.begin());
			vector<int> newVec(min(secondLargest, largest), max(secondLargest, largest));
			cout << medijan(newVec) + min(ite, secondLargestIte) + 1 << endl;
		}
	}
}